// 1位元七段顯示器數碼管(共陰)
// 定義 Arduino 5~12 分別對應到數碼管的 DP, A, B, C, D, E, F, G 等腳位

int pin_DP = 5;  // 對應數碼管的腳位  5
int pin_A = 6;   // 對應數碼管的腳位  7
int pin_B = 7;   // 對應數碼管的腳位  6
int pin_C = 8;   // 對應數碼管的腳位  4
int pin_D = 9;   // 對應數碼管的腳位  2
int pin_E = 10;  // 對應數碼管的腳位  1
int pin_F = 11;  // 對應數碼管的腳位  9
int pin_G = 12;  // 對應數碼管的腳位 10

byte words[] = {
  // .ABCDEFG 
    B00110111,  // H 
    B01001111,  // E 
    B00001110,  // L 
    B00001110,  // L 
    B01111110,  // O 
    B10000000,  // . 
    B01111110,  // 0 
    B00110000,  // 1
    B01101101,  // 2
    B01111001,  // 3
    B00110011,  // 4
    B01011011,  // 5
    B01011111,  // 6
    B01110000,  // 7
    B01111111,  // 8
    B01111011,  // 9
    B10000000   // . 
};

int words_length = 17;

void setup(){
  pinMode(pin_DP, OUTPUT);
  pinMode(pin_A, OUTPUT);
  pinMode(pin_B, OUTPUT);
  pinMode(pin_C, OUTPUT);
  pinMode(pin_D, OUTPUT);
  pinMode(pin_E, OUTPUT);
  pinMode(pin_F, OUTPUT);
  pinMode(pin_G, OUTPUT);
}

void loop(){
  for(int i=0; i<words_length; i++){
    showIt(words[i]);   // 顯示一個字元
    delay(900);         // 顯示 0.9秒
    clearLED();         // 關閉數碼管
    delay(100);         // 關閉 0.1秒
  }
  delay(5000);
}

void showIt(byte data){
  int quotient = 0;
  int remainder = 0;
  remainder= data % 2;

  // 取得 G 值
  if(remainder == 1){
    digitalWrite(pin_G, HIGH);
  } else {
    digitalWrite(pin_G, LOW);
  }

  // 取得 F 值
  quotient = data / 2;
  remainder= quotient % 2;
  if(remainder == 1){
    digitalWrite(pin_F, HIGH);
  } else {
    digitalWrite(pin_F, LOW);
  }

  // 取得 E 值
  quotient = quotient / 2;
  remainder= quotient % 2;
  if(remainder == 1){
    digitalWrite(pin_E, HIGH);
  } else {
    digitalWrite(pin_E, LOW);
  }  
 
  // 取得 D 值
  quotient = quotient / 2;
  remainder= quotient % 2;
  if(remainder == 1){
    digitalWrite(pin_D, HIGH);
  } else {
    digitalWrite(pin_D, LOW);
  }
 
  // 取得 C 值
  quotient = quotient / 2;
  remainder= quotient % 2;
  if(remainder == 1){
    digitalWrite(pin_C, HIGH);
  } else {
    digitalWrite(pin_C, LOW);
  }
 
  // 取得 B 值
  quotient = quotient / 2;
  remainder= quotient % 2;
  if(remainder == 1){
    digitalWrite(pin_B, HIGH);
  } else {
    digitalWrite(pin_B, LOW);
  }
 
  // 取得 A 值
  quotient = quotient / 2;
  remainder= quotient % 2;
  if(remainder == 1){
    digitalWrite(pin_A, HIGH);
  } else {
    digitalWrite(pin_A, LOW);
  }

  // 取得 DP 值
  quotient = quotient / 2;
  remainder= quotient % 2;
  if(remainder == 1){
    digitalWrite(pin_DP, HIGH);
  } else {
    digitalWrite(pin_DP, LOW);
  }
}

void clearLED(){
  // 將所有 PIN 腳的輸出均設為 LOW
  digitalWrite(pin_DP, LOW);
  digitalWrite(pin_A, LOW);
  digitalWrite(pin_B, LOW);
  digitalWrite(pin_C, LOW);
  digitalWrite(pin_D, LOW);
  digitalWrite(pin_E, LOW);
  digitalWrite(pin_F, LOW);
  digitalWrite(pin_G, LOW);
}
