/* Include DigitLedDisplay Library */
#include "DigitLedDisplay.h"
/* Arduino Pin to Display Pin
   11 to DIN,
   7  to CS,
   13 to CLK */
#define DIN  11
#define CS   7
#define CLK  13

// 定義七段顯示器字元顯示的二進位碼
#define SHOW_H  B00110111
#define SHOW_E  B01001111 
#define SHOW_L  B00001110
#define SHOW_O  B01111110
#define SHOW_POINT  B10000000
#define SHOW_BLANK  B00000000




DigitLedDisplay ld = DigitLedDisplay(DIN, CS, CLK);

void setup() {
  /* Set the brightness min:1, max:15 */
  ld.setBright(10);
  /* Set the digit count */
  ld.setDigitLimit(8);
}

void loop() {
  // 第 1 段測試
  ld.printDigit(11111111);
  delay(1000);
  testPrintDigit01();
  
  // 第 2 段測試
  ld.printDigit(22222222);
  delay(1000);
  ld.clear();  
  testPrintDigit02();
  
  // 第 3 段測試
  ld.printDigit(33333333);
  delay(1000);
  testWrite();
  
  // 第 4 段測試
  ld.printDigit(44444444);
  delay(1000);
  testOnOff();
}

void testPrintDigit01() {
  // 由1~8的數字依序右移一格顯示
  long number = 12345678; // 必須使用長整數 
  for(int i=0; i < 8; i++){
    ld.printDigit(number);
    delay(500);
    ld.clear();
    number = number / 10L;
  } 
  delay(500); 
  ld.clear();
}

void testPrintDigit02() {
  // 分兩組分別顯示 0~99
  for (int i = 0; i < 100; i++) {
    ld.printDigit(i);
    /* Start From Digit 4 */
    ld.printDigit(i, 4);
    delay(50);
  }
  delay(500);   
  ld.clear();
}

byte show_word[] = { 
  SHOW_H, SHOW_E, SHOW_L, SHOW_L,
  SHOW_O, SHOW_POINT, SHOW_BLANK, SHOW_BLANK
};
void testWrite() {
  // HELLO. 的跑馬燈
  for (int i = 6; i < 40; i++) {
    ld.write(8, show_word[(i+6)%8]);
    ld.write(7, show_word[(i+7)%8]);
    ld.write(6, show_word[i%8]);
    ld.write(5, show_word[(i+1)%8]);
    ld.write(4, show_word[(i+2)%8]);
    ld.write(3, show_word[(i+3)%8]);
    ld.write(2, show_word[(i+4)%8]);
    ld.write(1, show_word[(i+5)%8]);
    delay(300);
  } 
}

void testOnOff() {
  // 利用 on(), off() 函數產生閃爍效果
  // 顯示 HELLO.
  ld.write(8, SHOW_BLANK);  // 空白
  ld.write(7, SHOW_BLANK);  // 空白
  ld.write(6, SHOW_H);  // H
  ld.write(5, SHOW_E);  // E
  ld.write(4, SHOW_L);  // L
  ld.write(3, SHOW_L);  // L
  ld.write(2, SHOW_O);  // O
  ld.write(1, SHOW_POINT);  // .
  // 閃爍 10 次
  for (int i = 0; i <= 10; i++) {
    /* Display off */
    ld.off();
    delay(150);

    /* Display on */
    ld.on();
    delay(150);
  }
  delay(500);
}
